using UnityEngine;
using System.Collections;

public class s_PhysicsBase : MonoBehaviour
{
	public float mGravity = 21f;	 	//How much gravity is affecting you
	public float mMaxFallSpeed = 20f;	//Your max falling speed
	public float mMoveSpeed = 7f;		//How fast you move left and right
	[System.NonSerialized][HideInInspector]
	public Vector3 mMoveVector;			//The vector for where you are going
	
	float mDisToFloorTol = 0.1f;
	protected float mVerticalVelocity;
	protected CharacterController mController = null;
	
	//Only the player needs to call this to be honest
	protected void Init()
	{
		//Get a controller if you have one (only player should have one)
		if (GetComponent<CharacterController>() != null)
			mController = (CharacterController)gameObject.GetComponent("CharacterController");
	}
	
	protected void Move()
	{
		if(mMoveVector.magnitude > 1)
			mMoveVector = Vector3.Normalize(mMoveVector);
		
		mMoveVector *= mMoveSpeed;
		
		mMoveVector = new Vector3(mMoveVector.x, mVerticalVelocity, 0);
		
		ApplyGravity();
		
		//Only player has special move function
		if (mController != null && mController.enabled)
			mController.Move(mMoveVector * Time.deltaTime);
		else
			transform.Translate(mMoveVector * Time.deltaTime, Space.World);
	}
	
	void ApplyGravity()
	{
		//Actually makes you fall
		if(mMoveVector.y > -mMaxFallSpeed)
			mMoveVector = new Vector3(mMoveVector.x, (mMoveVector.y - mGravity * Time.deltaTime), mMoveVector.z);
		
		//Reset gravity when you hit the floor.
		if (mController != null)
		{
			//Player needs to be pushed into the floor for collision detection
			if(mController.isGrounded && mMoveVector.y < -1)
				mMoveVector = new Vector3(mMoveVector.x, -1, mMoveVector.z);	
		}
		else
		{
			if(IsGrounded(gameObject) && mMoveVector.y < 0)
				mMoveVector = new Vector3(mMoveVector.x, 0, mMoveVector.z);
		}
	}
	
	//This is for applying velocity when rewind stops
	public void AddVerticalVelocity(float aYVel, int aFrames)
	{	
		aYVel -= (mGravity * Time.deltaTime)*aFrames;
		mVerticalVelocity = aYVel;
		
		Move();
	}
	
	public bool IsGrounded(GameObject aGO)
	{
		if (mController != null)
			return mController.isGrounded;
		else
			//Thanks aldonaletto! http://answers.unity3d.com/questions/196381/how-do-i-check-if-my-rigidbody-player-is-grounded.html
  			return Physics.Raycast(aGO.collider.bounds.center, -Vector3.up, aGO.collider.bounds.extents.y + mDisToFloorTol);
	}
	
}
